mytree.symmetric.age <-
function (age, distributionspname, distributionspparameters, distributionextname, distributionextparameters, complete=TRUE, labellivingsp="sp.", labelextinctsp="ext.")
{ 
# # # # # # # # # DECLARATIONS  MACHINE # # # # # # # # # 
	stop <- FALSE
	mytree <-list(edge=NULL, tip.label=NULL, edge.length=NULL, Nnode=NULL, root.edge=NULL)
	class(mytree) <- "phylo"
	edge <- matrix(c(-1,-2), ncol=2)
	leaves <- NULL
	realleaves <- NULL
	extinct <- NULL
	tip.label <- NULL
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

#generation of the expression that creates the random number from the desired distribution
	udistributionspparameters <- capture.output (cat(distributionspparameters, sep=","))
	udistributionextparameters <- capture.output (cat(distributionextparameters, sep=","))
	rnumbsp <- parse(text=paste(distributionspname, "(1,", udistributionspparameters,")"))
	rnumbext <- parse(text=paste(distributionextname, "(1,", udistributionextparameters,")"))
# eval(rnumbsp) #draws one random number from the chosen distribution	
# eval(rnumbext) #draws one random number from the chosen distribution	

# tracing back the time for one species until origin
trajectory  <- function (trace){
	#trace should indicate the edge number that is to be followed until the origin
	trajectory  <- NULL
	while ( length( which(edge[,2] == trace)) ){
		atual  <- which(edge[,2] == trace)
		trajectory  <- c(edge.length[atual], trajectory)
		trace  <- edge[atual,1]
 	}
  	return(trajectory)
}

# initial if, in case the (-1,-2) edge get extinct or bigger than age
spt <- eval(rnumbsp)
#to remove NaN warnings messages
{
if (distributionextparameters[1] == 0)
{
	extt <- suppressWarnings(eval(rnumbext))
}
else
{
	extt <- eval(rnumbext)
}
}

# to see if the user simulates with extinction = ZERO and avoid error generated by expression-distribution when rate equals zero
{
if (is.nan(extt))
{
	extt <- spt +1 # we add so that the sp will allways occurs first, and we will never have an extinction
}
}


{
if (spt <= extt)
{
	status <- "sp" #occurred an speciation
	edge.length <- spt
	leaves <- -2
}
else
{
	status <- "ext" #occurred an extinction
	edge.length <- extt
	extinct <- -2
	stop <- TRUE
}
}

{
if (min(spt,extt) >= age)
{
	edge.length <- age
	stop <- TRUE
	{
	if (status == "sp")
	{
		realleaves <- leaves
		leaves <- NULL					
	}
	else
	{
		realleaves <- extinct			
		extinct <- NULL
	}
	}
}
}
# for the while (increase of the tree)
while (stop == FALSE) 
{
	species <- leaves[1]
	nextsp <- min(edge[,2])
	i <- 1
		for (i in 1:2)
		{ 
			edge <- rbind( edge, c(species, (nextsp - i) ) )
			spt <- eval(rnumbsp)
			#to remove NaN warnings messages
			{
			if (distributionextparameters[1] == 0)
			{
				extt <- suppressWarnings(eval(rnumbext))
			}
			else
			{
				extt <- eval(rnumbext)
			}
			}

			# if to see if the user simulates with extinction = ZERO and avoid error generated by expression-distribution when rate equals zero
			{
			if (is.nan(extt))
			{
				extt <- spt +1 # we add 1 so that the sp will allways occurs first, so that we will never have an extinction
			}
			}
			
			{
			if (spt <= extt)
			{
				status <- "sp" #occurred an speciation
				edge.length <- c(edge.length, spt)
				leaves <- c(leaves, (nextsp - i))
			}
			else
			{
				status <- "ext" #occurred an extinction
				edge.length <- c(edge.length, extt)
				extinct <- c(extinct, (nextsp - i))
			}
			}
			#	
			traject <- trajectory(nextsp - i)
			{
			if ( sum(traject) >= age) 
			{
				edge.length[length(edge.length)] <- age - sum(traject[1: (length(traject)-1) ] ) # reduce the last edge.length to make the sum be equals age
				# now we see if it extincted or speciated to know from were to take it out and put into the realleaves
				{
				if (status == "sp")
				{
					realleaves <- c( realleaves, leaves[length(leaves)] )
					leaves <- leaves[-length(leaves)]					
				}
				else
				{
					realleaves <- c( realleaves, extinct[length(extinct)] )			
					extinct <- extinct[-length(extinct)]
				}
				}

			}  
			}
		}
	leaves <- leaves[-1]
		{
		if (length(leaves) == 0)
		{
			stop <- TRUE	
		}
		}
}
# final if... in case of (stop == TRUE) , we write the tree "mytree"
{
if (stop == TRUE) 
{
		#### replacing to the ape format
		prealleaves <- realleaves
		{
		if (length(realleaves) > 0)
		{
				realleaves <- c(1:length(realleaves))
				i <- 1
				for (i in 1:length(realleaves))
				{
						edge[ which(edge[,2] == prealleaves[i]), 2 ] <- realleaves[i]
				}
      	tip.label <- paste(labellivingsp, realleaves, sep = "")
      	}
      	}
		pextinct <- extinct
		{
      	if (length(extinct) > 0)
      	{
			extinct <- c((length(realleaves)+1):(length(realleaves)+length(extinct)))
			i <- 1
			for (i in 1:length(extinct))
			{
					edge[ which(edge[,2] == pextinct[i]), 2 ] <- extinct[i]
			}
		tip.label <- c(tip.label, paste(labelextinctsp, extinct, sep = "") )
		}
		}
		#regarding the edges that lead to an extinct or leaving final species, but are not the final edges
		potheredges <- levels(as.factor(edge[edge <0]))
		otheredges <- rev(seq((max(realleaves, extinct)+1), length.out=length(potheredges)))
		#substituting...
		i <- 1
		for (i in 1:length(potheredges))
		{
				edge[ edge == potheredges[i] ] <- otheredges[i]
		}
	mytree$edge <- edge
	mytree$tip.label <- tip.label
	mytree$edge.length <- edge.length
	mytree$Nnode <-  length(realleaves) + length(extinct)
	mytree$root.edge <- edge.length[1]
}	
}

#final handling before plotting to handle ape limitations
{
if (length(realleaves) == 0)
{
	# in case no specie is surviving until final simulation time
	mytree <- 0
}
else
{
	{
	if ( length(realleaves) == 1 & complete == FALSE)
	{
		#in case only one specie is surviving, even if other specification events occurred in the history
		mytree <- 1
	}
	else
	{
		{
		if (length(realleaves)==1 & length(extinct)==0 & complete==TRUE)
		{
			#in case only one species is surviving and was the only existing one
			mytree <- 1
		}
		else
		{
			#in case non of the above condition is fulfilled, there will be a tree with no initial branch, tree starts at the MRCA
			#this is done to be able to plot using the `ape` package 
			mytree <- collapse.singles(mytree)
			#cheking status of 'complete'. Take or dont take extincted species out of final tree
			{
			if (complete == FALSE)	
			{
				mytree<- drop.fossil(mytree)
			}
			}		
		}
		}		
	}
	}	
}
}
#mytree
return(mytree)
}
