% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Treeness.R
\name{Treeness}
\alias{Treeness}
\alias{Stemminess}
\title{Relative length of internal branches}
\usage{
Treeness(tree)

Stemminess(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}, or a list of trees
of class \code{list} or \code{multiPhylo}.}
}
\value{
\code{Treeness()} returns a numeric vector reporting the treeness of each
\code{tree}.
}
\description{
Treeness (also termed stemminess) is the proportion of a tree's length found
on internal branches \insertCite{Lanyon1988}{TreeTools}.
Insofar as external branches do not contain phylogenetic (grouping) signal,
trees with a high treeness can be interpreted as containing a higher
signal:noise ratio \insertCite{Phillips2003}{TreeTools}.
}
\examples{
lowTree <- BalancedTree(6, lengths = c(1, 1, 4, 4, 4, 1, 1, 4, 4, 4))
plot(lowTree)
Treeness(lowTree)
highTree <- BalancedTree(6, lengths = c(6, 6, 1, 1, 1, 6, 6, 1, 1, 1))
plot(highTree)
Treeness(c(lowTree, highTree))
}
\references{
\insertAllCited{}
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{LongBranch}()},
\code{\link{MatchEdges}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{PathLengths}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree properties}
