% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsoilFunctions.R
\name{soil_specific_heat}
\alias{soil_specific_heat}
\title{Soil Specific Heat}
\usage{
soil_specific_heat(x_o, x_m, x_w, rho_so)
}
\arguments{
\item{x_o}{\code{numeric} volume fraction of organic material (0-1).}

\item{x_m}{\code{numeric} volume fraction of minerals (0-1).}

\item{x_w}{\code{numeric} volume fraction of water (0-1).}

\item{rho_so}{\code{numeric} particle density of soil in (\ifelse{html}{\out{kg m<sup>-3</sup>}}{\eqn{kg m^-3}{ASCII}}) (bulk density).}
}
\value{
\code{numeric} soil specific heat (\ifelse{html}{\out{J kg<sup>-1</sup> K<sup>-1</sup>}}{\eqn{J kg^-1 K^-1}{ASCII}}).
}
\description{
The function estimates soil specific heat (\ifelse{html}{\out{J kg<sup>-1</sup> K<sup>-1</sup>}}{\eqn{J kg^-1 K^-1}{ASCII}}) using the methods of \insertCite{deVries1963;textual}{TrenchR}. The function incorporates the volume fraction of organic material, minerals, and water in soil.
}
\examples{
  soil_specific_heat(x_o    = 0.01, 
                     x_m    = 0.6, 
                     x_w    = 0.2, 
                     rho_so = 1620)

}
\references{
\insertAllCited{}
}
\seealso{
Other soil temperature functions: 
\code{\link{soil_conductivity}()},
\code{\link{soil_temperature_equation}()},
\code{\link{soil_temperature_function}()},
\code{\link{soil_temperature_integrand}()},
\code{\link{soil_temperature}()}
}
\author{
Joseph Grigg
}
\concept{soil temperature functions}
