% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_summary.R
\name{variable_summary}
\alias{variable_summary}
\title{Computes mean and optional probabilities for a given
variable.}
\usage{
variable_summary(var_name, var_matrix, probs)
}
\arguments{
\item{var_name}{String, name of the dependent variable}

\item{var_matrix}{Numeric matrix samplesN x observationsN.}

\item{probs}{A numeric vector of quantiles to compute.}
}
\value{
data.frame with "{var_name}" column for the mean and
"{var_name}_{prob}" columns for each probability.
}
\description{
Computes mean and optional probabilities for a given
variable.
}
\examples{
variable_summary("test", matrix(1:1000, ncol = 1), c(0.05, 0.95))
}
\keyword{internal}
