% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.prod_mod.R
\name{plot.prod_mod}
\alias{plot.prod_mod}
\title{Plotting production models}
\usage{
\method{plot}{prod_mod}(x, display_MSY = TRUE, ...)
}
\arguments{
\item{x}{a object of the class \code{"prod_mod"}}

\item{display_MSY}{logical; should MSY be displayed in the graph?}

\item{...}{optional parameters of plot function}
}
\description{
This function plots CPUE and yield values against fishing effort
     resulting from the production models (\link{prod_mod}).
}
\examples{
data(trawl_fishery_Java)
output <-  prod_mod(data = trawl_fishery_Java)
plot(output, display_years = TRUE)

}
\references{
Fox, W. W. Jr., 1970. An exponential surplus-yield model for optimizing exploited fish
populations. \emph{Trans.Am.Fish.Soc.}, 99:80-88

Graham, M., 1935. Modern theory of exploiting a fishery and application to North Sea
trawling. \emph{J.Cons.CIEM}, 10(3):264-274

Schaefer, M., 1954. Some aspects of the dynamics of populations important to the
management of the commercial marine fisheries. \emph{Bull.I-ATTC/Bol. CIAT}, 1(2):27-56

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}

