% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvTcdf.R
\name{mvTcdf}
\alias{mvTcdf}
\title{Truncated multivariate student cumulative distribution}
\usage{
mvTcdf(l, u, Sig, df, n = 1e+05)
}
\arguments{
\item{l}{lower bound for truncation (infinite values allowed)}

\item{u}{upper bound for truncation}

\item{Sig}{covariance matrix}

\item{df}{degrees of freedom}

\item{n}{sample size}
}
\value{
a list with components
\itemize{
\item{\code{prob}: }{estimated value of probability Pr\eqn{(l<X<u)} }
\item{\code{relErr}: }{estimated relative error of estimator}
\item{\code{upbnd}: }{theoretical upper bound on true Pr\eqn{(l<X<u)} }
}
}
\description{
Computes an estimator of the probability Pr\eqn{(l<X<u)},
where \eqn{X} is a centered multivariate student vector
with scale matrix \code{Sig} and degrees of freedom \code{df}.
Infinite values for vectors \code{u} and \code{l} are accepted.
}
\details{
Monte Carlo method uses sample size \code{n}; the larger
the \code{n}, the smaller the relative error of the estimator;
}
\note{
If you want to estimate Pr\eqn{(l<Y<u)},
where \eqn{Y} follows a Student distribution with \code{df} degrees of freedom,
location vector \code{m} and scale matrix \code{Sig},
then use \code{mvTqmc(Sig, l - m, u - m, nu, n)}.
}
\examples{
 d <- 15; nu <- 30;
 l <- rep(2, d); u <- rep(Inf, d);
 Sig <- 0.5 * matrix(1, d, d) + 0.5 * diag(1, d);
 est <- mvTcdf(l, u, Sig, nu, n = 1e4)
 # mvtnorm::pmvt(lower = l, upper = u, df = nu, sigma = Sig)
\dontrun{
d <- 5
Sig <- solve(0.5*diag(d)+matrix(0.5, d,d))
# mvtnorm::pmvt(lower = rep(-1,d), upper = rep(Inf, d), df = 10, sigma = Sig)[1]
mvTcdf(rep(-1, d), u = rep(Inf, d), Sig = Sig, df = 10, n=1e4)$prob
}
}
\references{
Z. I. Botev (2017), \emph{The Normal Law Under Linear Restrictions:
Simulation and Estimation via Minimax Tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24

Z. I. Botev and P. L'Ecuyer (2015), Efficient probability estimation
and simulation of the truncated multivariate Student-t distribution,
Proceedings of the 2015 Winter Simulation Conference, pp. 380-391
}
\seealso{
\code{\link{mvTqmc}}, \code{\link{mvrandt}}, \code{\link{mvNqmc}}, \code{\link{mvrandn}}
}
\author{
\code{Matlab} code by Zdravko Botev, \code{R} port by Leo Belzile
}
\keyword{internal}
