% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTrust.r
\name{.ReadTrust_BarcodeReport}
\alias{.ReadTrust_BarcodeReport}
\title{Read TRUST4 barcode_report file.}
\usage{
.ReadTrust_BarcodeReport(barcode_report_file = NULL, verbose = TRUE)
}
\arguments{
\item{barcode_report_file}{character. Path to barcode_report file generated by TRUST4.}

\item{verbose}{logical. Print progress. Default is TRUE}
}
\value{
A VDJ information data.frame
}
\description{
\code{.ReadTrust_BarcodeReport} reads a barcode_report file generated by TRUST4.
Note that it could be xx_barcode_report.tsv but not xx_report.tsv.
(.gz supported)
}
\examples{
barcode_report_file = system.file('extdata', 'TRUST4_barcode_report.tsv.gz', package = 'TrustVDJ')
barcode_report = .ReadTrust_BarcodeReport(barcode_report_file, verbose = FALSE)
head(barcode_report)

}
