% Generated by roxygen2 (4.0.0): do not edit by hand
\name{turtle_param}
\alias{turtle_col}
\alias{turtle_lty}
\alias{turtle_lwd}
\alias{turtle_param}
\title{Set Display Options}
\usage{
turtle_param(col = NULL, lwd = NULL, lty = NULL)

turtle_col(col)

turtle_lwd(lwd)

turtle_lty(lty)
}
\arguments{
\item{col}{numeric or character; trace color, see e.g. \code{\link{colors}}
and \code{\link{gpar}}.}

\item{lty}{numeric; trace line type, see \code{\link{gpar}}.}

\item{lwd}{numeric; trace line width, see \code{\link{gpar}}.}
}
\description{
Sets the display options for the Turtle's trace.
It is possible to change its color, line type and
line width.
}
\details{
The Turtle must be initialized prior to using
this function, see \code{\link{turtle_init}}.
}
\examples{
turtle_init()
turtle_forward(5)
turtle_up()
turtle_forward(3)
turtle_down()
turtle_left(90)
turtle_forward(5)
turtle_param(col = "red", lwd = 2, lty = 2)
turtle_forward(5)
}
\seealso{
Other TurtleGraphics: \code{\link{TurtleGraphics-package}};
  \code{\link{turtle_backward}},
  \code{\link{turtle_forward}}, \code{\link{turtle_move}};
  \code{\link{turtle_down}}, \code{\link{turtle_up}};
  \code{\link{turtle_do}}; \code{\link{turtle_getangle}},
  \code{\link{turtle_getpos}}; \code{\link{turtle_goto}},
  \code{\link{turtle_setangle}},
  \code{\link{turtle_setpos}}; \code{\link{turtle_hide}},
  \code{\link{turtle_show}}; \code{\link{turtle_init}};
  \code{\link{turtle_left}}, \code{\link{turtle_right}},
  \code{\link{turtle_turn}}; \code{\link{turtle_reset}};
  \code{\link{turtle_status}}
}

