% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_hashtag}
\alias{plot_hashtag}
\title{Plot tweets containing certain hashtag}
\usage{
plot_hashtag(
  data,
  region = ".",
  alpha = 0.01,
  hashtag = "",
  ignore_case = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame of tweets parsed by \link[Twitmo]{load_tweets} or returned by \link[Twitmo]{pool_tweets}.}

\item{region}{Character vector specifying region. Returns a world \link[maps]{map} by default.
For higher resolutions specify a region.}

\item{alpha}{A double between 0 and 1 specifying the opacity of plotted points.
See \link[maps]{iso3166} for country codes.}

\item{hashtag}{Character vector of the hashtag you want to plot.}

\item{ignore_case}{Logical, if TRUE will ignore case of hashtag.}

\item{...}{Extra arguments passed to \link[graphics]{polygon} or \link[graphics]{lines}.}
}
\value{
Maps where each dot represents a tweet.
}
\description{
Plot the locations of certain hashtag on a static map with base plot.
}
\details{
This function can be used to generate high resolution spatial plots of hashtags
Works with data frames of tweets returned by \link[Twitmo]{pool_tweets} as well as data frames
read in by \link[Twitmo]{load_tweets} and then augmented by lat/lng coordinates with \link[rtweet]{lat_lng}.
For larger view resize the plot window then call \code{plot_tweets} again.
}
\examples{

\dontrun{
library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Plot tweets on mainland USA region
plot_hashtag(mytweets,
             region = "USA(?!:Alaska|:Hawaii)",
             hashtag = "breakfast",
             ignore_case=TRUE,
             alpha=1)

# Add title
title("My hashtags on a map")
}

}
\seealso{
\link[maps]{map}, \link[maps]{iso3166}
}
