% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMU_ActiGraph_Scripts.R
\name{get_directions}
\alias{get_directions}
\title{Calculate direction changes per five seconds in sliding windows}
\usage{
get_directions(big_data, window_secs = 5)
}
\arguments{
\item{big_data}{a numeric vector on which to perform the calculation}

\item{window_secs}{size of the sliding window, in seconds}
}
\value{
a numeric vector of values, giving the number of direction changes in the sliding window that corresponds to each epoch of data
}
\description{
Calculate direction changes per five seconds in sliding windows
}
\examples{
\dontrun{
##All possible directions
directions <-
  c("N", "NNE", "NE", "ENE",
    "E", "ESE", "SE", "SSE",
    "S", "SSW", "SW", "WSW",
    "W", "WNW", "NW", "NNW")

##Reproducible results
set.seed(55)
direction_vector <- sample(directions, 50, replace = TRUE)

##Vector of direction changes per 5-s. First and last two values are always NA
get_directions(direction_vector)
}

}
