% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dates&Times.R
\name{get_minute}
\alias{get_minute}
\title{Numerical Minute of the Day.}
\usage{
get_minute(timestamp, format = "\%Y-\%m-\%d \%H:\%M:\%S", rational = FALSE)
}
\arguments{
\item{timestamp}{A character vector containing timestamp information}

\item{format}{The date-time format of the \code{timestamp} vector}

\item{rational}{A logical scalar. Use rational number to represent seconds?}
}
\description{
Converts a timestamp to a numerical value between 0 (midnight) and 1439
(23:59). Seconds can be represented using a rational decimal.
}
\examples{
\dontrun{
key_times <-
    paste("2018-03-15",
          c("00:00:00",
            "01:00:00",
            "12:00:00",
            "23:59:59"))

TwoRegression:::get_minute(key_times)
TwoRegression:::get_minute(key_times, rational = TRUE)
}

}
\keyword{internal}
