% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_2rm__main.R
\name{summary.TwoRegression}
\alias{summary.TwoRegression}
\alias{new_summary}
\alias{new_cut}
\alias{new_model}
\title{Summary method for TwoRegression objects}
\usage{
\method{summary}{TwoRegression}(object, ...)

new_summary(object)

new_cut(
  z,
  object,
  element = c("sed_roc", "walkrun_roc"),
  label = c("sedentary", "walk_run")
)

new_model(
  z,
  object,
  element = c("walkrun_model", "intermittent_model"),
  label = c("walk_run", "intermittent_activity")
)
}
\arguments{
\item{object}{The TwoRegression object to summarize}

\item{...}{Arguments passed to \code{\link{DualCP_LOSO}}}

\item{z}{An intermediate summary object for internal use}

\item{element}{character. Element name to search for in \code{z}}

\item{label}{character. A label for the cut point}
}
\value{
and object of class \code{summary.TwoRegression}, containing
  information about the cut-points and diagnostics, regression model
  performance, and overall algorithm performance during
  leave-one-participant-out-cross-validation.
}
\description{
Summary method for TwoRegression objects
}
\examples{

set.seed(307)

data(all_data, package = "TwoRegression")
all_data$PID <- rep(
  c("Test1", "Test2"),
  each = ceiling(nrow(all_data) / 2)
)[seq(nrow(all_data))]

fake_sed <- c("Lying", "Sitting")
fake_lpa <- c("Sweeping", "Dusting")
fake_cwr <- c("Walking", "Running")
fake_ila <- c("Tennis", "Basketball")

fake_activities <- c(fake_sed, fake_lpa, fake_cwr, fake_ila)

all_data$Activity <-
  sample(fake_activities, nrow(all_data), TRUE)

all_data$fake_METs <-
  ifelse(all_data$Activity \%in\% c(fake_sed, fake_lpa),
    runif(nrow(all_data), 1, 2),
    runif(nrow(all_data), 2.5, 8)
  )

ex_2rm <- fit_2rm(
  data = all_data,
  activity_var = "Activity",
  sed_cp_activities = c(fake_sed, fake_lpa),
  sed_activities = fake_sed,
  sed_cp_var = "ENMO",
  sed_METs = 1.25,
  walkrun_activities = fake_cwr,
  walkrun_cp_var = "ENMO_CV10s",
  met_var = "fake_METs",
  walkrun_formula = "fake_METs ~ ENMO",
  intermittent_formula = "fake_METs ~ ENMO + I(ENMO^2) + I(ENMO^3)"
)

summary(
  ex_2rm,
  subject_var = "PID",
  MET_var = "fake_METs",
  activity_var = "Activity"
)
}
\keyword{internal}
