% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{XenaPrepare}
\alias{XenaPrepare}
\title{Prepare (Load) datasets to R download from UCSC Xena}
\usage{
XenaPrepare(objects, objectsName = NULL, comment = "#", na = c("",
  "NA", "[Discrepancy]"), ...)
}
\arguments{
\item{objects}{a object of character vector or data.frame. If \code{objects} is data.frame,
it should be returned object of \code{XenaDownload} function. More easier way is
that objects can be character vector specify local files/directory and download urls.}

\item{objectsName}{specify objectsName of result}

\item{comment}{a character specify comment rows in files}

\item{na}{a character vectory specify \code{NA} values in files}

\item{...}{other arguments transfer to \code{read_tsv} function of \code{readr} package}
}
\value{
a list contains file data, which in way of tibbles
}
\description{
Prepare (Load) datasets to R download from UCSC Xena
}
\examples{
xe = XenaGenerate(subset = XenaHostNames == "TCGA")
hosts(xe)
xe_query = XenaQuery(xe)

# xe_download = XenaDownload(xe_query)
# dat = XenaPrepare(xe_download)

}
\author{
Shixiang Wang <w_shixiang@163.com>
}
