% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCvalidate.R
\name{UCvalidate}
\alias{UCvalidate}
\title{UCvalidate}
\usage{
UCvalidate(sys, printScreen = TRUE)
}
\arguments{
\item{sys}{an object of type \code{UComp} created with \code{UC}}

\item{printScreen}{print to screen or just return output table}
}
\value{
The same input object with the appropriate fields 
filled in, in particular:
\itemize{
\item table: Estimation and validation table
}
}
\description{
Shows a table of estimation and diagnostics results for UC models.
Equivalent to print or summary.
The table shows information in four sections:
Firstly, information about the model estimated, the relevant 
periods of the seasonal component included, and further information about
convergence.
Secondly, parameters with their names are provided, the asymptotic standard errors, 
the ratio of the two, and the gradient at the optimum. One asterisk indicates 
concentrated-out parameters and two asterisks signals parameters constrained during estimation.
Thirdly, information criteria and the value of the log-likelihood.
Finally, diagnostic statistics about innovations, namely, the Ljung-Box Q test of absense
of autocorrelation statistic for several lags, the Jarque-Bera gaussianity test, and a
standard ratio of variances test.
}
\examples{
\dontrun{
m1 <- UC(log(gdp))
m1 <- UCvalidate(m1)
}
}
\seealso{
\code{\link{UC}}, \code{\link{UCforecast}}, \code{\link{UCfilter}}, 
         \code{\link{UCsmooth}}, \code{\link{UCdisturb}}, \code{\link{UCcomponents}},
         \code{\link{UChp}}
}
\author{
Diego J. Pedregal
}
