\name{Data}
\alias{Data}
\title{Specify Umacs Parameter As Data}
\description{
Generates an object of class \code{Data} that embeds the argument value
as an object \emph{locally} in the sampler function generated by \code{\link{Sampler}}.
The name of the object is taken to be the associated parameter name.

Usually a call to this function is not necessary,
since \code{Data} is implicitly called when the value of a named
parameter in the argument list of \code{Sampler} is
an R object but not a function,numeric object or an
instance of the Umacs class \code{Parameter}.

}
\usage{
Data(x)
}
\arguments{
  \item{x}{ a numeric data object to be associated to the model parameter }
}
\details{
The parameter is supposed to be `unmodeled data,' specified by
the likelihood.

}
\value{An object of class \code{Data}.}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{
The \code{\link{Sampler}} function recognizes numeric, named parameters
and wraps them by default in \code{Data(...)}, so usually this function
is never explicitly called by the user.

To embed an R function locally into the sampler function,
use \code{\link{LocalFunction}} instead.

To embed just any non-function object locally into the sampler function,
use \code{\link{LocalObject}} instead.

}
\seealso{
\code{\link{Umacs-package}} for an overview of the Umacs package.

\code{\link{Sampler}} for how to create a sampler function; see the vignette for details.

Package `rv'.

}
\examples{}
\keyword{iteration}
