% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{fit.EP17}
\alias{fit.EP17}
\title{Fit CLSI EP17 Model Using log-transformaed X and Y.}
\usage{
fit.EP17(x, y, DF, typeY = c("vc", "sd", "cv"), k = 2, ...)
}
\arguments{
\item{x}{(numeric) mean concentrations of samples}

\item{y}{(numeric) variability at 'x' on VC-, SD-, or CV-scale}

\item{DF}{(numeric) vector of degrees of freedom linked to variabilities 'y'
used in derivation of deviance and AIC}

\item{typeY}{(character) specifying the scale of 'y'-values}

\item{k}{(numeric) numeric specifying the 'weight' of the equivalent
degrees of freedom (edf) part in the AIC formula.}

\item{...}{additional arguments}
}
\value{
(list) with items "x" and "y" as provided, and "x.out" and "y.out"
         representing X- and Y-coordiantes of fitted values for plotting
}
\description{
This function fits the model proposed in CLSI EP17 by log-transforming
CV (Y) as well as mean-values (X) und performing a linear regression of these.
More specifically CV = A * Conc^B, where Conc = mean concentration of a sample and CV is
on the percent-scale, is fitted by ordinary least squares (OLS) estimation of
log(CV) = A + B * log(Conc). Fitted values are subsequently back-transformed
using formula cv = exp(a) * C^b, where cv, a and b represent estimates of CV, A and B.
}
\details{
The AIC is computed following the implementation of \code{extractAIC.lm} in the
'stats' package with the adaption of using 'n = sum(df)' instead of 'n' being the number
of residuals. The 'df' come from a precision analysis, thus, there are far more observations
used to fit this model than indicated by the number of residuals.
}
\examples{
\donttest{
# data from appendix D of CLSI EP17-A2 (pg. 54)
EP17.dat <- data.frame(
 Lot=c(rep("Lot1", 9), rep("Lot2", 9)),
	Mean=c(	0.04, 0.053, 0.08, 0.111, 0.137, 0.164, 0.19, 0.214, 0.245,
			0.041, 0.047, 0.077, 0.106, 0.136, 0.159, 0.182, 0.205, 0.234),
	CV=c(40.2, 29.6, 19.5, 15.1, 10.0, 7.4, 6.0, 7.5, 5.4,
		 44.1, 28.8, 15.1, 17.8, 11.4, 9.2, 8.4, 7.8, 6.2),
 SD=c(0.016, 0.016, 0.016, 0.017, 0.014, 0.012, 0.011, 0.016, 0.013,
		 0.018, 0.014, 0.012, 0.019, 0.016, 0.015, 0.015, 0.016, 0.014),
 DF=rep(1, 18)
)

EP17.dat$VC <- EP17.dat$SD^2

lot1 <- subset(EP17.dat, Lot=="Lot1")
lot2 <- subset(EP17.dat, Lot=="Lot2")

# function fit.EP17 is not exported, use package namesspace in call
fit.lot1 <- VFP:::fit.EP17(x=lot1$Mean, y=lot1$CV, typeY="cv", DF=lot1$DF)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
