% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{getMat.VCA}
\alias{getMat.VCA}
\title{Transform list of VCA-object into VFP-matrix required for fitting.}
\usage{
getMat.VCA(obj, vc = 1)
}
\arguments{
\item{obj}{(list) of VCA-objects}

\item{vc}{(integer, character) either an integer specifying a variance component
or the name of a variance component}
}
\description{
Transform list of VCA-object into VFP-matrix required for fitting.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
mat <- getMat.VCA(lst)
mat
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
