% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_visitation_model.R
\name{check_arguments}
\alias{check_arguments}
\title{Check Arguments}
\usage{
check_arguments(
  log_scale,
  popularity_proxy,
  onsite_usage,
  ref_series,
  constant,
  omit_trend,
  trend,
  ...
)
}
\arguments{
\item{log_scale}{A Boolean specifying whether or not the results should be returned in the log scale.}

\item{popularity_proxy}{A vector which stores a time series which may be used as a proxy for the social media time series in the log scale. The length of popularity_proxy must be the same as that of onsite_usage.}

\item{onsite_usage}{A vector which stores on-site usage in the log scale for a particular social media platform and recreational site.}

\item{ref_series}{A numeric vector specifying the original visitation series in the log scale. If such series is available, then its length must be the same as that of time_series.}

\item{constant}{A numeric specifying the constant term in the model. This constant is understood as the mean of the trend-adjusted time_series. If ref_series is supplied, the constant is overwritten by the least squares estimate.}

\item{omit_trend}{This is obsolete and is left only for compatibility. A Boolean specifying whether or not to consider the trend component to be 0. The default option is TRUE, in which case, the trend component is 0. If}

\item{trend}{A character string specifying how the trend is modeled. Can be any of NULL, "linear", "none", and "estimated", where "none" and "estimated" correspond to \code{omit_trend} being TRUE and FALSE, respectively. If NULL, then it follows the value specified in \code{omit_trend}.}

\item{...}{Additional arguments.}
}
\value{
No return value, called for extra information.
}
\description{
Check arguments.
}
