% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geoboundaries_api_data.R
\name{get_geoboundaries_api_data}
\alias{get_geoboundaries_api_data}
\title{Request metadata from GeoBoundaries API}
\usage{
get_geoboundaries_api_data(iso3, admin_level, release = "gbOpen")
}
\arguments{
\item{iso3}{A three-letter capitalized character string. Must follow the ISO-3166 Alpha-3 country code
standard (\url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}).}

\item{admin_level}{An integer specifying the administrative level. It should be between 0 and 5.}

\item{release}{A character string specifying the release type. It should be one of 'gbOpen', 'gbHumanitarian', or 'gbAuthoritative'. Default is 'gbOpen'.}
}
\value{
A list containing the GeoBoundaries API data and file paths to admin boundaries in .geojson format.
}
\description{
This function retrieves GeoBoundaries data from the API based on the specified release, ISO3 country code, and administrative level.
If data is not found at the specified administrative level, it attempts to retrieve data from a lower administrative level until data
is found or the lowest level is reached.
}
\examples{
\donttest{

tmp <- get_geoboundaries_api_data(iso3 = 'MCO', admin_level = 2, release = 'gbOpen')
head(tmp)

}
}
