% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechet_func.R
\name{frechet_func}
\alias{frechet_func}
\title{Compute the Frechet functional/The objective value of the barycenter problem}
\usage{
frechet_func(bary, data)
}
\arguments{
\item{bary}{An object representing a measure, for which the Frechet value should be computed. Should be one of the following: 
A matrix, representing an image; A path to a file containing an image; 
A \link[transport]{wpp-object}; 
A \link[transport]{pp-object};
A list containing an entry named `positions` with the support of the measure and an entry named `weights` containing the weights of the support points;
A list containing en entry named `positions`` specifying the support of a measure with uniform weights.}

\item{data}{A list of objects which should be compared to bary. Each element should be one of the following:
A matrix, representing an image; A path to a file containing an image; 
A \link[transport]{wpp-object}; 
A \link[transport]{pp-object};
A list containing an entry named `positions` with the support of the measure and an entry named `weights` containing the weights of the support points;
A list containing en entry named `positions`` specifying the support of a measure with uniform weights.}
}
\value{
A real number specifying the Frechet value of the input object for the given dataset.
}
\description{
This function computes the objective value of the barycenter problem for a given measure and a given dataset of measures.
}
