% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_dist.R
\name{ws_dist}
\alias{ws_dist}
\title{Compute the p-Wasserstein distance between two measures}
\usage{
ws_dist(A, B, p = 2, sampling = FALSE, S = NULL, R = NULL)
}
\arguments{
\item{A}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{B}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{p}{A positive real number specifying the power of the Wasserstein distance.}

\item{sampling}{A boolean specifying whether a stochastic approximation (Sommerfeld et al., 2019) should be used to approximate the distance.}

\item{S}{A positive integer specifying the number of samples drawn in the stochastic approximation.}

\item{R}{The number of repetitions averaged over in the stochastic approximation.}
}
\value{
A number specifying the computed p-Wasserstein distance.
}
\description{
This is essentially a wrapper function of \link[transport]{transport}. It has the advantage of allowing 
more general input objects, such as images or matrices, without the user having to manually convert these objects.
}
\examples{
P1<-transport::random32a$mass
P2<-transport::random32b$mass
P1<-P1/sum(P1)
P2<-P2/sum(P2)
ws_dist(P1,P2)
}
\references{
M Sommerfeld, J Schrieber, Y Zemel, and A Munk (2019).
Optimal transport: Fast probabilistic approximations with exact solvers.  Journal of Machine Learning Research 20(105):1--23.
}
