% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistHistBeta}
\alias{PlotDistHistBeta}
\title{Plot empirical rate data as a histogram plus matching beta}
\usage{
PlotDistHistBeta(frm, xvar, title, ..., bins = 30,
  hist_color = "darkgray", beta_color = "blue", mean_color = "blue",
  sd_color = "darkgray")
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{force later arguments to bind by name}

\item{bins}{passed to geom_histogram(). Default: 30}

\item{hist_color}{color of empirical histogram}

\item{beta_color}{color of matching theoretical beta}

\item{mean_color}{color of mean line}

\item{sd_color}{color of 1-standard devation lines (can be NULL)}
}
\value{
ggplot2 plot
}
\description{
Compares empirical rate data to a beta distribution with the same mean and standard deviation.
}
\details{
Plots the histogram of the empirical distribution and the density of the matching beta distribution.
Also plots the mean and plus/minus one standard deviation.

The number of bins for the histogram defaults to 30.
The binwidth can also be passed in instead of the number of bins.
}
\examples{

set.seed(52523)
N = 100
pgray = 0.1  # rate of gray horses in the population
herd_size = round(runif(N, min=25, 50))
ngray = rbinom(N, herd_size, pgray)
hdata = data.frame(n_gray=ngray, herd_size=herd_size)

# observed rate of gray horses in each herd
hdata$rate_gray = with(hdata, n_gray/herd_size)

title = "Observed prevalence of gray horses in population"

PlotDistHistBeta(hdata, "rate_gray", title) +
  ggplot2::geom_vline(xintercept = pgray, linetype=4, color="maroon") +
  ggplot2::annotate("text", x=pgray+0.01, y=0.01, hjust="left",
                    label = paste("True prevalence =", pgray))

# no sd lines
PlotDistHistBeta(hdata, "rate_gray", title,
                    sd_color=NULL)
}
