% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signal.R
\name{extract_signal}
\alias{extract_signal}
\title{Extract signal from a wavelet spectra using a traced period curve}
\usage{
extract_signal(
  tracked_cycle_curve = NULL,
  wavelet = NULL,
  period_up = 1.2,
  period_down = 0.8,
  add_mean = TRUE,
  tracked_cycle_period = NULL,
  extract_cycle = NULL,
  tune = FALSE,
  plot_residual = FALSE
)
}
\arguments{
\item{tracked_cycle_curve}{Traced period result from the \code{track_period_wavelet}
function completed using the \code{completed_series}.
The input can be pre-smoothed using the the \code{loess_auto} function.}

\item{wavelet}{wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{period_up}{Upper period as a factor of the to be extracted cycle \code{Default=1.2}.}

\item{period_down}{Lower period as a factor of the to be extracted cycle \code{Default=0.8}.}

\item{add_mean}{Add mean to the extracted cycle \code{Default=TRUE}.}

\item{tracked_cycle_period}{Period in time of the traced cycle.}

\item{extract_cycle}{Period of the to be extracted cycle.}

\item{tune}{Convert record from the depth to the time domain using the traced period \code{Default=FALSE}.}

\item{plot_residual}{Plot the residual signal after extraction of set cycle \code{Default=FALSE}.}
}
\value{
Returns a matrix with 2 columns
The first column is depth/time
The second column is extracted signal
}
\description{
Extract signal power from the wavelet in the depth domain using the traced period.
}
\examples{
\donttest{
#Extract the 405 kyr eccentricity cycle from the the magnetic susceptibility \cr
#record of the Sullivan core and use the Gabor uncertainty principle to define \cr
#the mathematical uncertainty of the analysis and use a factor of that standard \cr
#deviation to define boundaries.

#Perform the CWT
mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#Track the 405 kyr eccentricity cycle in a wavelet spectra

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (metres)",
#                                   x_lab = "depth (metres)")

#Instead of tracking, the tracked solution data set \code{\link{mag_track_solution}} is used \cr
mag_track <- mag_track_solution


mag_track_complete <- completed_series(
  wavelet = mag_wt,
  tracked_curve = mag_track,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE
)

# smooth the tracking of the 405 kyr eccentricity cycle
mag_track_complete <- loess_auto(time_series = mag_track_complete,
genplot = FALSE, print_span = FALSE)

# extract the 405 kyr eccentricity cycle from the wavelet spectrum and use the \cr
# tracked cycle curve and set factors of the extracted cycle as boundaries

mag_405_ecc  <- extract_signal(
tracked_cycle_curve = mag_track_complete,
wavelet = mag_wt,
period_up = 1.2,
period_down = 0.8,
add_mean = TRUE,
tracked_cycle_period = 405,
extract_cycle = 405,
tune = FALSE,
plot_residual = FALSE
)
}
}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}
}
\author{
Code based on the reconstruct function of the 'WaveletComp' R package
which is based on the wavelet 'MATLAB' code written by Christopher Torrence and Gibert P. Compo (1998).
}
