% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.lcsm}
\alias{wp.lcsm}
\title{Statistical Power Curve for Univariate Latent Change Score Models based on Monte Carlo Simulation}
\usage{
wp.lcsm(N = 100, T = 5, R = 1000, betay = 0, my0 = 0, mys = 0,
  varey = 1, vary0 = 1, varys = 1, vary0ys = 0, alpha = 0.05, ...)
}
\arguments{
\item{N}{Sample size. It is 100 by default.}

\item{T}{Number of measurement occasions. It is 5 by default.}

\item{R}{Number of replications for the Monte Carlo simulation. It is 1000 by default.}

\item{betay}{Parameter in the model: The compound rate of change. Its default value is 0.}

\item{my0}{Parameter in the model: Mean of the initial latent score. Its default value is 0.}

\item{mys}{Parameter in the model: Mean of the linear constant effect. Its default value is 0.}

\item{varey}{Parameter in the model: Variance of the measurement error/uniqueness score. Its default value is 1.}

\item{vary0}{Parameter in the model: Variance of the initial latent score. Its default value is 1.}

\item{varys}{Parameter in the model: Variance of the linear constant effect. Its default value is 0.}

\item{vary0ys}{Parameter in the model: Covariance of the initial latent score and the linear constant effect. Its default value is 0.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{...}{Extra arguments. It is not required.}
}
\value{
An object of the power analysis.
The output of the R function includes 4 main pieces of information for each parameter in the model. The first is the Monte Carlo estimate (mc.est).
It is calculated as the mean of the R sets of parameter estimates from the simulated data.
Note that the Monte Carlo estimates should be close to the population parameter values used in the model.
The second is the Monte Carlo standard deviation (mc.sd), which is calculated as the standard deviation of the R sets of parameter estimates.
The third is the Monte Carlo standard error (mc.se), which is obtained as the average of the R sets of standard error estimates of the parameter estimates.
Lastly, mc.power is the statistical power for each parameter.
}
\description{
A longitudinal design often involves data collection on multiple variables from multiple participants at multiple times.
Growth curve models (GCM) are structural equation models for longitudinal data analysis (\cite{McArdle & Epstein, 1987; McArdle & Nesselroade, 2014}). 
Latent change score models (LCSM) combine difference equations with growth curves to investigate change in longitudinal studies .
LCSM provied an efficient way to model nonlinear trajectory (e.g., \cite{McArdle, 2000; McArdle & Hamagami, 2001; Hamagami et al., 2010}).
This function is used to conduct power analysis for univariate LCSMs based on a Monte Carlo method ( a method also used by \cite{Muthén & Muthén, 2002; Thoemmes et al., 2010; Zhang & Wang, 2009; Zhang, 2014}).
For each Monte Carlo replication, the Maximum likelihood ratio test is used for the model, while the Wald test is used for the parameter test.
The method can obtain the power for testing each individual parameter of the models such as the change rate and coupling parameters.
}
\examples{
\dontrun{
#Power analysis for a univariate LCSM
#Power for each parameter given sample size, number of measurement occasions,
# true effect (true values of parameters), and significance level:
wp.lcsm(N = 100, T = 5, R = 1000, betay = 0.1, my0 = 20, mys = 1.5,
        varey = 9, vary0 = 2.5, varys = .05, vary0ys = 0, alpha = 0.05)   
#           pop.par mc.est mc.sd mc.se mc.power  N  T
#    betay   0.10   0.103  0.043 0.044  0.664   100 5
#    my0    20.00  19.999  0.324 0.319  1.000   100 5
#    mys     1.50   1.418  1.106 1.120  0.274   100 5
#    varey   9.00   8.961  0.724 0.732  1.000   100 5
#    vary0   2.50   2.463  1.151 1.139  0.583   100 5
#    vary0ys 0.00  -0.004  0.408 0.403  0.048   100 5
#    varys   0.05   0.053  0.173 0.175  0.050   100 5
#  
#  #To calculate the Type I error rate and power for parameters
  wp.lcsm(N = 100, T = 5, R = 1000, betay = 0, my0 = 0, mys = 0,
              varey = 1, vary0 = 1, varys = 1, vary0ys = 0,alpha = 0.05)
#           pop.par	mc.est	mc.sd	mc.se	mc.power N	T
#    betay   0		0.001	0.056	0.056	0.046	100 5
#    my0		0		0.001	0.129	0.126	0.056	100 5
#    mys		0		0.002	0.105	0.105	0.044	100 5
#    varey   1		0.994	0.083	0.081	1.000	100 5
#    vary0   1		0.990	0.236	0.230	1.000	100 5
#    vary0ys	0		-0.005	0.136	0.136	0.044	100 5
#    varys   1		1.006	0.227	0.227	1.000	100 5

# To generate a power curve for different sample sizes for a univariate LCSM
res <- wp.lcsm(N = seq(100, 200, 10), T = 5, R = 1000, betay = 0.1,
                          my0 = 20, mys = 1.5, varey = 9, vary0 = 2.5,
                               varys = .05, vary0ys = 0, alpha = 0.05)
#plot(res, parameter='betay')
#plot(res, parameter='mys')

# To generate a power curve for different numbers of occasions for a univariate LCSM
res <- wp.lcsm(N = 100, T = 4:10, R = 1000, betay = 0.1, my0 = 20, mys = 1.5,
                varey = 9, vary0 = 2.5, varys = .05, vary0ys = 0, alpha = 0.05)
#plot(res, parameter='betay')
#plot(res, parameter='mys')
}

}
\references{
Zhang, Z., & Liu, H. (2018). Sample Size and Measurement Occasion Planning for Latent Change Score Models through Monte Carlo Simulation. In E. Ferrer, S. M. Boker, and K. J. Grimm (Eds.) Advances in Longitudinal Models for Multivariate Psychology: A Festschrift for Jack McArdle.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}