## ----setup, include=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, eval=T)
options(width = 200, digits= 4)

me_ok <- requireNamespace("marginaleffects", quietly = TRUE)
set.seed(1000)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library("cobalt")
data("lalonde", package = "cobalt")
head(lalonde)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
bal.tab(treat ~ age + educ + race + married + nodegree + re74 + re75,
        data = lalonde, estimand = "ATT", thresholds = c(m = .05))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library("WeightIt")
W.out <- weightit(treat ~ age + educ + race + married + nodegree + re74 + re75,
                  data = lalonde, estimand = "ATT", method = "glm")
W.out #print the output

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
summary(W.out)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
bal.tab(W.out, stats = c("m", "v"), thresholds = c(m = .05))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
W.out <- weightit(treat ~ age + educ + race + married + nodegree + re74 + re75,
                  data = lalonde, estimand = "ATT", method = "ebal")
summary(W.out)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
bal.tab(W.out, stats = c("m", "v"), thresholds = c(m = .05))

## ----message=FALSE, eval = me_ok----------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Fit outcome model
fit <- lm_weightit(re78 ~ treat * (age + educ + race + married +
                                     nodegree + re74 + re75),
                   data = lalonde, weightit = W.out)

# G-computation for the treatment effect
library("marginaleffects")
avg_comparisons(fit, variables = "treat",
                newdata = subset(lalonde, treat == 1))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("msmdata")
head(msmdata)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library("cobalt") #if not already attached
bal.tab(list(A_1 ~ X1_0 + X2_0,
             A_2 ~ X1_1 + X2_1 +
               A_1 + X1_0 + X2_0,
             A_3 ~ X1_2 + X2_2 +
               A_2 + X1_1 + X2_1 +
               A_1 + X1_0 + X2_0),
        data = msmdata, stats = c("m", "ks"),
        which.time = .all)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Wmsm.out <- weightitMSM(list(A_1 ~ X1_0 + X2_0,
                             A_2 ~ X1_1 + X2_1 +
                               A_1 + X1_0 + X2_0,
                             A_3 ~ X1_2 + X2_2 +
                               A_2 + X1_1 + X2_1 +
                               A_1 + X1_0 + X2_0),
                        data = msmdata, method = "glm",
                        stabilize = TRUE)
Wmsm.out

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
summary(Wmsm.out)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
bal.tab(Wmsm.out, stats = c("m", "ks"),
        which.time = .none)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Fit outcome model
fit <- glm_weightit(Y_B ~ A_1 * A_2 * A_3 * (X1_0 + X2_0),
                    data = msmdata,
                    weightit = Wmsm.out,
                    family = binomial)

## ----eval = me_ok-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library("marginaleffects")
(p <- avg_predictions(fit,
                      variables = c("A_1", "A_2", "A_3"),
                      type = "response"))

## ----eval = me_ok-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
hypotheses(p, "b8 - b1 = 0")

