% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_chat.R
\name{parse_chat}
\alias{parse_chat}
\title{Parsing exported 'WhatsApp' chat logs as a dataframe}
\usage{
parse_chat(
  path,
  os = "auto",
  language = "auto",
  anonimize = "add",
  consent = NA,
  emoji_dictionary = "internal",
  smilie_dictionary = "wikipedia",
  rpnl = " start_newline ",
  rpom = " media_omitted ",
  verbose = FALSE
)
}
\arguments{
\item{path}{Character string containing the file path to the exported 'WhatsApp' chat log as a .txt file.}

\item{os}{Operating system of the phone the chat was exported from. Default "auto" tries to automatically detect the OS. Also supports "android" or "iOS".}

\item{language}{Indicates the language setting of the phone with which the messages were exported. Default is "auto" trying to match either 'English' or 'German'. More languages might be supported in the future.}

\item{anonimize}{TRUE results in the vector of sender names being anonymized and columns containing personal identifiable information to be deleted or restricted, FALSE displays the actual names and all content, "add" adds
anonomized columns to the full info columns. Do not blindly trust this and always double check.}

\item{consent}{String containing a consent message. All messages from chatters who have not posted this *exact* message into the chat will be deleted. Default is NA, no deleting anything.}

\item{emoji_dictionary}{Dictionary for emoji matching. Can use a version included in this package when set to "internal" or
an updated data frame created by \code{\link[WhatsR]{download_emoji}} passed as a character string containing the path to the file.}

\item{smilie_dictionary}{Value "emoticons" uses \code{\link[qdapRegex]{ex_emoticon}} to extract smilies, "wikipedia" uses a more inclusive custom list
of smilies containing all mentions from https://de.wiktionary.org/w/index.php?title=Verzeichnis:International/Smileys
and manually added ones.}

\item{rpnl}{Replace newline. A character string for replacing line breaks within messages for the parsed message for better readability. Default is " start_newline ".}

\item{rpom}{Replace omitted media. A character string replacing the indicator for omitted media files for better readability. Default is " media_omitted ".}

\item{verbose}{Prints progress messages for parse_chat() to the console if TRUE, default is FALSE.}
}
\value{
A dataframe containing one row per message and 11,15, or 19 columns, depending on the setting of the anonimize parameter
}
\description{
Creates a data frame from an exported 'WhatsApp' chat log containing one row per message. Some columns
are saved as lists using the I() function so that multiple elements can be stored per message while still maintaining
the general structure of one row per message. These columns should be treated as lists or unlisted first.
}
\examples{
data <- parse_chat(system.file("englishandroid24h.txt", package = "WhatsR"))
}
