% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_ios.R
\name{parse_ios}
\alias{parse_ios}
\title{Parsing raw 'WhatsApp' chat log according to iOs text structure}
\usage{
parse_ios(
  chatlog,
  newline_indicator = "\\n",
  media_omitted = "<media omitted>",
  media_indicator = "^<attached:\\\\s(.)*?\\\\.(.)*?>$",
  sent_location = paste0("Location: (?=https:\\\\/\\\\/maps\\\\.google\\\\.com\\\\/",
    "\\\\?q=\\\\d\\\\d.\\\\d{6}\\\\,\\\\d\\\\.\\\\d{6})"),
  live_location = "^live location shared$",
  datetime_indicator = paste("(?!^)(?=\\\\[((\\\\d{2}\\\\.\\\\d{2}\\\\.\\\\d{2})|",
    "(\\\\d{1,2}\\\\/\\\\d{1,2}\\\\/\\\\d{2})),\\\\s\\\\d{1,2}\\\\:\\\\d{2}((\\\\:\\\\d{2}\\\\",
    "s(?i:(pm|am)))|(\\\\s(?i:(pm|am)))|(\\\\:\\\\d{2}\\\\])|(\\\\:\\\\d{2})|(\\\\s))\\\\])",
    sep = ""),
  newline_replace = " start_newline ",
  media_replace = " media_omitted "
)
}
\arguments{
\item{chatlog}{'WhatsApp' chat preprocessed by \code{\link[WhatsR]{parse_chat}}}

\item{newline_indicator}{Character string defining character for newline indicators. Default is a Unicode newline.}

\item{media_omitted}{Character string inserted by 'WhatsApp' instead of file names when not exporting media.}

\item{media_indicator}{Character string for detecting media and file attachments.}

\item{sent_location}{Regex for detecting auto generated messages for locations shared via chat.}

\item{live_location}{Regex for detecting auto generated messages for locations shared via chat.}

\item{datetime_indicator}{Regex for detecting the DateTime indicator at the beginning of each message.}

\item{newline_replace}{Replacement string for a newline character in parsed message. Default is " start_newline ".}

\item{media_replace}{Replacement string for omitted media files. Default is " media_omitted ".}
}
\value{
A data frame containing the timestamp, name of the sender and message body
}
\description{
Creates a data frame from an exported 'WhatsApp' chat log containing one row per message
and a column for DateTime when the message was send, name of the sender and body of the message. Only works as an intermediary function
called from within \code{\link[WhatsR]{parse_chat}}
}
\examples{
ParsedChat <- parse_ios("[29.01.18, 23:33:00] Alice: Hello?\\\\n [29.01.18, 23:45:01] Bob: Hello")
}
