% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/categories.R
\name{categories_in_page}
\alias{categories_in_page}
\title{Retrieves categories associated with a page.}
\usage{
categories_in_page(language = NULL, project = NULL, domain = NULL, pages,
  properties = c("sortkey", "timestamp", "hidden"), limit = 50,
  show_hidden = FALSE, clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{pages}{A vector of page titles, with or without spaces, that you want to retrieve
categories for.}

\item{properties}{The properties you want to retrieve about the categories.
Options are "sortkey" (the key that sorts the way the page is stored in each category),
"timestamp" (when the category was added to that page) and "hidden" (tags those categories
in the returned list that are 'hidden' from readers).}

\item{limit}{The maximum number of categories you want to retrieve for each page. Set
to 50 by default.}

\item{show_hidden}{Whether or not to include 'hidden' categories in the categories
that are retrieved - these are usually associated with the maintenance of Wikipedia
and its internal processes. Set to FALSE by default.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
Retrieves categories associated with a page (or list of pages) on a MediaWiki instance
}
\examples{
#Retrieve the categories for the "New Age" article on en.wiki
cats <- categories_in_page("en", "wikipedia", pages = "New Age")

#Retrieve the categories for the "New Age" article on rationalwiki.
rw_cats <- categories_in_page(domain = "rationalwiki.org", pages = "New Age")
}
\seealso{
\code{\link{pages_in_category}} for pages in a specified category.
}

