/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class FastColumnBuilder
extends ColumnBuilder {
    public FastColumnBuilder(int nrows, boolean forceConversion, boolean takeCached, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        super(nrows, forceConversion, takeCached, evaluator, onErrorCell, dateTimeFormat);
    }

    protected void handleCell(Cell c, CellValue cv) {
        switch (cv.getCellTypeEnum()) {
            case BLANK: {
                this.addMissing();
                return;
            }
            case BOOLEAN: {
                this.addValue(c, cv, DataType.Boolean);
                break;
            }
            case NUMERIC: {
                this.addValue(c, cv, DataType.Numeric);
                break;
            }
            case STRING: {
                this.addValue(c, cv, DataType.String);
                break;
            }
            case FORMULA: {
                String msg = "Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
                break;
            }
            case ERROR: {
                String msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(cv.getErrorValue());
                this.cellError(msg);
                break;
            }
            default: {
                String msg = "Unexpected cell type detected for cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
            }
        }
    }
}

