print.summary.plant3d <- function(x, ...){

	cat("                                     Total leaf area (m2) =", signif(x$LA,digits=x$nsignif), "\n")
	cat("                                     Mean leaf size (cm2) =", signif(x$meanleafsize,digits=x$nsignif), "\n")
	cat("                                         Number of leaves =", signif(x$nleavesp,digits=x$nsignif), "\n")
	cat("                                    Mean leaf length (cm) =", signif(x$leaflen,digits=x$nsignif), "\n")
	cat("                                    Mean leaf angle (deg) =", signif(x$meanleafang,digits=x$nsignif), "\n")
	cat("              Mean leaf angle weighted by leaf area (deg) =", signif(x$wmeanleafang,digits=x$nsignif), "\n")
	cat("                        Ellipsoidal leaf angle dist. par. =", signif(x$Xellipsoid,digits=x$nsignif), "\n")
    cat("\n")
	cat("                         Crown volume (convex hull) (dm3) =", signif(1000*x$crownvol,digits=x$nsignif), "\n")
	cat("                    Crown surface area (convex hull) (m2) =", signif(x$crownsurf,digits=x$nsignif), "\n")
	cat("                           Crown density (AL/AC) (m2 m-2) =", signif(x$LA / x$crownsurf, digits=x$nsignif),"\n")
	cat("                                          Crown width (m) =", signif(x$cw,digits=x$nsignif), "\n")
	cat("                                         Crown length (m) =", signif(x$cl,digits=x$nsignif), "\n")
	cat("               Crown projected area (2D convex hull) (m2) =", signif(x$crownproj,digits=x$nsignif), "\n")
	cat("                                          Total height(m) =", signif(x$htot,digits=x$nsignif), "\n")
	cat("                                    Crown shape index (-) =", signif(x$cshape,digits=x$nsignif), "\n")
	cat("\n")
	cat("                         Stem + branch surface area (cm2) =", signif(10^4*x$stemsurf,digits=x$nsignif), "\n")
	cat("                               Stem + branch volume (cm3) =", signif(10^6*x$stemvol,digits=x$nsignif), "\n")
	cat("                                  Stem base diameter (mm) =", signif(x$stemdiam, digits=x$nsignif), "\n")
	cat("                                    Mean pipe length (mm) =", signif(x$meanpath, digits=x$nsignif), "\n")
	cat("                   Standard deviation of pipe length (mm) =", signif(x$sdpath, digits=x$nsignif), "\n")
	cat("                          Total woody segment length (mm) =", signif(x$totlen, digits=x$nsignif), "\n")
	cat("\n")
	cat("    Expected distance to 5 nearest leaves (no edge corr.) =", signif(x$Ek,digits=x$nsignif), "\n")
	cat("  Expected distance to 5 nearest leaves (with edge corr.) =", signif(x$Ek2,digits=x$nsignif), "\n")
	cat("                    Observed distance to 5 nearest leaves =", signif(x$Ok,digits=x$nsignif), "\n")
	cat("                     Dispersion parameter (no edge corr.) =", signif(x$disp,digits=x$nsignif), "\n")
	cat("                   Dispersion parameter (with edge corr.) =", signif(x$disp2,digits=x$nsignif), "\n\n")
	if(!is.na(x$STARbar))
		cat("                                         STARbar (m2 m-2) =", signif(x$STARbar,digits=x$nsignif), "\n\n")
}