% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyApproximation.R
\name{FuzzyApproximation}
\alias{FuzzyApproximation}
\title{Function for approximation with the help of methods other than in FuzzyNumbers package}
\usage{
FuzzyApproximation(value, method = "ExpectedValueCore", piecewise = FALSE, ...)
}
\arguments{
\item{value}{Fuzzy number to approximate.}

\item{method}{The selected approximation method.}

\item{piecewise}{If \code{piecewise=TRUE} is set, then the methods "Naive","NearestEuclidean" (from the FuzzyNumbers package) produce piecewise linear fuzzy number as the
output, otherwise they result in trapezoidal fuzzy number.}

\item{...}{Additional parameters passed to other functions (like approximation method from the FuzzyNumbers package).}
}
\value{
The output is a fuzzy number (triangular or trapezoidal one) described by
classes from \code{FuzzyNumbers} package.
}
\description{
\code{FuzzyApproximation} approximates the given fuzzy number.
}
\details{
The function approximates the fuzzy number given by \code{value} with the method selected by
\code{method}. The following approximations are possible: \code{ExpectedValueCore}--preserving the
expected value and the core of \code{value}, \code{TriangularSupportDist}--constructs the
triangular fuzzy number based on minimization of \code{DpqDistance}, preserving the support of \code{value},
and the approximation methods from the FuzzyNumbers package (namely: \code{Naive, NearestEuclidean, ExpectedIntervalPreserving,
SupportCoreRestricted,SupportCorePreserving}).

The input value should be given by a fuzzy number described by classes from \code{FuzzyNumbers} package.
}
\examples{

library(FuzzyNumbers)

# prepare complex fuzzy number

A <- FuzzyNumber(-5, 3, 6, 20, left=function(x)
pbeta(x,0.4,3),
right=function(x) 1-x^(1/4),
lower=function(alpha) qbeta(alpha,0.4,3),
upper=function(alpha) (1-alpha)^4)

# find approximation

FuzzyApproximation (A)


}
