\name{maize.simule240}
\alias{maize.simule240}
\title{Wrapper function to run Maize model multiple times for multiple sets of parameter values and give Biomass at day240}
\usage{
  maize.simule240(X, weather, sdate, ldate, all = FALSE)
}
\arguments{
  \item{X}{: matrix of n row vectors of 7 parameters}

  \item{weather}{: weather data.frame for one single year}

  \item{sdate}{: sowing date}

  \item{ldate}{: last date}

  \item{all}{: if you want a matrix combining X and output
  (default = FALSE)}
}
\value{
  a matrix of biomass at day=240 for all combinations of
  parameters of X
}
\description{
  Wrapper function to run Maize model multiple times for
  multiple sets of parameter values and give Biomass at
  day240
}
\examples{
sy="18-2006"
weather = maize.weather(working.year=strsplit(sy,"-")[[1]][2],
  working.site=strsplit(sy,"-")[[1]][1],weather_all=weather_EuropeEU)
maize.simule240(maize.define.param(),weather, sdate=100, ldate=250, all=FALSE)
}

