% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{ci.plot}
\alias{ci.plot}
\title{Method for plotting qi simulations across a range within a variable, with confidence intervals}
\usage{
ci.plot(obj, qi="ev", var=NULL, ..., main = NULL, sub =
 NULL, xlab = NULL, ylab = NULL, xlim = NULL, ylim =
 NULL, legcol="gray20", col=NULL, leg=1, legpos=
 NULL, ci = c(80, 95, 99.9))
}
\arguments{
\item{obj}{A reference class zelig5 object}

\item{qi}{a character-string specifying the quantity of interest to plot}

\item{var}{The variable to be used on the x-axis. Default is the variable
across all the chosen values with smallest nonzero variance}

\item{...}{Parameters to be passed to the `truehist' function which is
implicitly called for numeric simulations}

\item{main}{a character-string specifying the main heading of the plot}

\item{sub}{a character-string specifying the sub heading of the plot}

\item{xlab}{a character-string specifying the label for the x-axis}

\item{ylab}{a character-string specifying the label for the y-axis}

\item{xlim}{Limits to the x-axis}

\item{ylim}{Limits to the y-axis}

\item{legcol}{``legend color'', an valid color used for plotting the line
colors in the legend}

\item{col}{a valid vector of colors of at least length 3 to use to color the
confidence intervals}

\item{leg}{``legend position'', an integer from 1 to 4, specifying the
position of the legend. 1 to 4 correspond to ``SE'', ``SW'', ``NW'', and
``NE'' respectively}

\item{legpos}{``legend type'', exact coordinates and sizes for legend.
Overrides argment ``leg.type''}

\item{ci}{vector of length three of confidence interval levels to draw.}
}
\value{
the current graphical parameters. This is subject to change in future
implementations of Zelig
}
\description{
Method for plotting qi simulations across a range within a variable, with confidence intervals
}
\author{
James Honaker
}

