% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bell.R
\name{Bell}
\alias{Bell}
\alias{A000110}
\title{Bell numbers}
\usage{
Bell(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000110}{A000110}, the \emph{n}th \emph{Bell} number is
the number of ways to partition a set of \code{n} labeled elements,
where the first 6 entries are 1, 1, 2, 5, 15, 52.
}
\examples{
## generate first 30 Bell numbers
first30 = Bell(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
