% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_collatz.R
\name{canvas_collatz}
\alias{canvas_collatz}
\title{Paint the Collatz Conjecture on Canvas}
\usage{
canvas_collatz(colors, background = '#fafafa', n = 200, 
                angle.even = 0.0075, angle.odd = 0.0145, side = FALSE)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{n}{the number of numbers to sample for the lines. Can also be a vector of numbers to use.}

\item{angle.even}{the angle (radials) to use after odd numbers.}

\item{angle.odd}{the angle (radials) to use after even numbers.}

\item{side}{logical. Whether to put the artwork on its side.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the Collatz conjecture on the canvas.
}
\examples{
\donttest{
set.seed(1)
canvas_collatz(colors = colorPalette('dark1'), n = 100)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
