% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_flame.R
\name{canvas_flame}
\alias{canvas_flame}
\title{Draw a Fractal Flame}
\usage{
canvas_flame(colors, background = "#000000",
             iterations = 1000000, zoom = 1, resolution = 1000,
             variations = NULL, blend = TRUE,
             display = c("colored", "logdensity"),
             post = FALSE, final = FALSE, extra = FALSE,
             verbose = FALSE)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{zoom}{a positive value specifying the amount of zooming.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}

\item{variations}{an integer (vector) specifying the variations to be included in the flame. The default \code{NULL} includes a random number of variations. See the details section for more information about possible variations.}

\item{blend}{logical. Whether to blend the variations (\code{TRUE}) or pick a unique variation in each iteration (\code{FALSE}). \code{blend = FALSE} significantly speeds up the computation time.}

\item{display}{a character indicating how to display the flame. \code{colored} (the default) displays colors according to which function they originate from. \code{logdensity} plots a gradient using the log density of the pixel count.}

\item{post}{logical. Whether to apply a post transformation in each iteration.}

\item{final}{logical. Whether to apply a final transformation in each iteration.}

\item{extra}{logical. Whether to apply an additional post transformation after the final transformation. Only has an effect when \code{final = TRUE}.}

\item{verbose}{logical. Whether to print information.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function implements the fractal flame algorithm.
}
\details{
The \code{variation} argument can be used to include specific variations into the flame. See the appendix in the references for examples of all variations. Possible variations are:

\itemize{
 \item{\code{0}: Linear}
 \item{\code{1}: Sine}
 \item{\code{2}: Spherical}
 \item{\code{3}: Swirl}
 \item{\code{4}: Horsehoe}
 \item{\code{5}: Polar}
 \item{\code{6}: Handkerchief}
 \item{\code{7}: Heart}
 \item{\code{8}: Disc}
 \item{\code{9}: Spiral}
 \item{\code{10}: Hyperbolic}
 \item{\code{11}: Diamond}
 \item{\code{12}: Ex}
 \item{\code{13}: Julia}
 \item{\code{14}: Bent}
 \item{\code{15}: Waves}
 \item{\code{16}: Fisheye}
 \item{\code{17}: Popcorn}
 \item{\code{18}: Exponential}
 \item{\code{19}: Power}
 \item{\code{20}: Cosine}
 \item{\code{21}: Rings}
 \item{\code{22}: Fan}
 \item{\code{23}: Blob}
 \item{\code{24}: PDJ}
 \item{\code{25}: Fan2}
 \item{\code{26}: Rings2}
 \item{\code{27}: Eyefish}
 \item{\code{28}: Bubble}
 \item{\code{29}: Cylinder}
 \item{\code{30}: Perspective}
 \item{\code{31}: Noise}
 \item{\code{32}: JuliaN}
 \item{\code{33}: JuliaScope}
 \item{\code{34}: Blur}
 \item{\code{35}: Gaussian}
 \item{\code{36}: RadialBlur}
 \item{\code{37}: Pie}
 \item{\code{38}: Ngon}
 \item{\code{39}: Curl}
 \item{\code{40}: Rectangles}
 \item{\code{41}: Arch}
 \item{\code{42}: Tangent}
 \item{\code{43}: Square}
 \item{\code{44}: Rays}
 \item{\code{45}: Blade}
 \item{\code{46}: Secant}
 \item{\code{47}: Twintrian}
 \item{\code{48}: Cross}
}
}
\examples{
\donttest{
set.seed(2)

# Simple example
canvas_flame(colors = c("dodgerblue", "green"))

# Advanced example (no-blend sine and spherical variations)
canvas_flame(colors = colorPalette("origami"), variations = c(1, 2), blend = FALSE)
}

}
\references{
\url{https://flam3.com/flame_draves.pdf}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
