% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_summary.R
\name{as_reactable}
\alias{as_reactable}
\title{Convert an aba summary to a interactive react table}
\usage{
as_reactable(object)
}
\arguments{
\item{object}{abaSummary. The aba summary to format as a reacttable.}
}
\value{
A reactable object from the reactable package
}
\description{
This function allows you to format an aba summary in the same way
which it is printed to the console using the \code{print} function. And then
it will be converted to an interactive react table that can be explored
in the Rstudio viewer or in a Shiny app.
}
\examples{

# use built-in data
data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit an aba model
model <- data \%>\% aba_model() \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(PET_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_PTAU181_bl,
    PLASMA_NFL_bl,
    c(PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_covariates(AGE, GENDER, EDUCATION) \%>\%
  set_stats('glm') \%>\%
  fit()

# default aba summary
model_summary <- model \%>\% aba_summary()

# convert summary to table
my_table <- model_summary \%>\% as_reactable()

}
