% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abn-toolbox.R
\name{scoreContribution}
\alias{scoreContribution}
\title{Compute the score's contribution in a network of each observation.}
\usage{
scoreContribution(object = NULL,
                         dag = NULL, data.df = NULL, data.dists = NULL,
                         verbose = FALSE)
}
\arguments{
\item{object}{an object of class '\code{abnLearned}'
produced by \code{\link{mostProbable}},
\code{\link{searchHeuristic}} or \code{\link{searchHillClimber}}.}

\item{dag}{a matrix or a formula statement (see details) defining the network structure,
a directed acyclic graph (DAG), see details for format.
Note that colnames and rownames must be set.}

\item{data.df}{a data frame containing the data used for learning the network,
binary variables must be declared as factors and
no missing values all allowed in any variable.}

\item{data.dists}{a named list giving the distribution for each node
in the network, see details.}

\item{verbose}{if \code{TRUE} then provides some additional output.}
}
\value{
A named list that contains the scores contributions:
maximum likelihood, aic, bic, mdl and diagonal values of the hat matrix.
}
\description{
This function computes the score's contribution of each observation to the total network score.
}
\details{
This function computes the score contribution of each observation
to the total network score.
This function is available only in the \code{mle} settings.
To do so one uses the \code{\link{glm}} and \code{\link{predict}} functions.
This function is an attempt to perform diagnostic for an ABN analysis.
}
\examples{
\dontrun{
## Use a subset of a built-in simulated data set
mydat <- ex1.dag.data[,c("b1","g1","p1")]

## setup distribution list for each node
mydists <- list(b1="binomial", g1="gaussian", p1="poisson")

## now build cache
mycache <- buildScoreCache(data.df = mydat, data.dists = mydists, max.parents = 2, method = "mle")

## Find the globally best DAG
mp.dag <- mostProbable(score.cache=mycache, score="bic", verbose = FALSE)

out <- scoreContribution(object = mp.dag)

## Observations contribution per network node
boxplot(out$bic)
}
}
\keyword{utilities}
