% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fca_bfca.R
\name{fca_bfca}
\alias{fca_bfca}
\title{BFCA balanced floating catchment area}
\usage{
fca_bfca(
  data,
  orig_col,
  dest_col,
  population_col,
  opportunity_col,
  decay_function,
  travel_cost_col
)
}
\arguments{
\item{data}{A \code{data.frame} with a travel cost matrix in long format,
containing the columns with origin ids, destination ids, the travel cost
between each origin-destination pair (this can be either in  terms of
travel time, distance or monetary costs), and number of population and
opportunities located in each origin and destination.}

\item{orig_col}{A \code{string} with the name of the column of origin ids.}

\item{dest_col}{A \code{string} with the name of the column of destination ids.}

\item{population_col}{A \code{string} with the name of the column of origin with
population count.}

\item{opportunity_col}{A \code{string} indicating the name of the column with the
number of opportunities / resources / services to be considered.}

\item{decay_function}{A \code{fuction} that converts travel cost (t_ij) into an
impedance factor used to weight opportunities. For convenience, the package
currently includes the following functions: \code{decay_bineary},
\code{decay_exponential}, \code{decay_exponential} and \code{decay_power}.
See the documentation of each decay function for more details.}

\item{travel_cost_col}{A \code{string} with the name of the column with travel
cost between origins and destinations. It can be either either travel time,
distance or monetary costs. Defaults to \code{travel_ime}.}
}
\value{
A \code{numeric} estimate of accessibility.
}
\description{
Calculates accessibility levels using the balanced floating catchment area
(BFCA) measure proposed by Paez et al. (2019). The BFCA metric calculate
accessibility accounting for the competition of resources and simultaneously
correcting for issues of inflation of demand and service levels that are
present in other accessibility metrics in the floating catchment area family.
}
\keyword{internal}
