% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floating_catchment_area.R
\name{floating_catchment_area}
\alias{floating_catchment_area}
\title{Floating catchment area accessibility}
\usage{
floating_catchment_area(
  travel_matrix,
  land_use_data,
  opportunity,
  travel_cost,
  demand,
  method,
  decay_function,
  group_by = character(0),
  fill_missing_ids = TRUE
)
}
\arguments{
\item{travel_matrix}{A data frame. The travel matrix describing the costs
(i.e. travel time, distance, monetary cost, etc.) between the origins and
destinations in the study area. Must contain the columns \code{from_id}, \code{to_id}
and any others specified in \code{travel_cost}.}

\item{land_use_data}{A data frame. The distribution of opportunities within
the study area cells. Must contain the columns \code{id} and any others
specified in \code{opportunity}.}

\item{opportunity}{A string. The name of the column in \code{land_use_data}
with the number of opportunities/resources/services to be considered when
calculating accessibility levels.}

\item{travel_cost}{A string. The name of the column in \code{travel_matrix}
with the travel cost between origins and destinations.}

\item{demand}{A string. The name of the column in \code{land_use_data} with the
number of people in each origin that will be considered potential
competitors.}

\item{method}{A string. Which floating catchment area measure to use.
Current available options are \code{"2sfca"} and \code{"bfca"}. More info in the
details.}

\item{decay_function}{A \code{fuction} that converts travel cost into an
impedance factor used to weight opportunities. This function should take a
\code{numeric} vector and also return a \code{numeric} vector as output, with the
same length as the input. For convenience, the package currently includes
the following functions: \code{\link[=decay_binary]{decay_binary()}}, \code{\link[=decay_exponential]{decay_exponential()}},
\code{\link[=decay_power]{decay_power()}} and \code{\link[=decay_stepped]{decay_stepped()}}. See the documentation of each decay
function for more details.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{travel_matrix} columns that should be used to group the
accessibility estimates by. For example, if \code{travel_matrix} includes a
departure time column, that specifies the departure time of each entry in
the data frame, passing \code{"departure_time"} to this parameter results in
accessibility estimates grouped by origin and by departure time.}

\item{fill_missing_ids}{A \code{logical}. When calculating grouped accessibility
estimates (i.e. when \code{by_col} is not \code{NULL}), some combinations of groups
and origins may be missing. For example, if a single trip can depart from
origin \code{A} at 7:15am and reach destination \code{B} within 55 minutes, but no
trips departing from \code{A} at 7:30am can be completed at all, this second
combination will not be included in the output. When \code{TRUE} (the default),
the function identifies which combinations would be left out and fills
their respective accessibility values with 0, which incurs in a
performance penalty.}
}
\value{
A data frame containing the accessibility estimates for each
origin/destination (depending if \code{active} is \code{TRUE} or \code{FALSE}) in the
travel matrix.
}
\description{
Calculates accessibility accounting for the competition of resources using a
measure from the floating catchment area (FCA) family. Please see the
details for the available FCA measures.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\section{Details}{

The package currently includes two built-in FCA measures:
\itemize{
\item 2SFCA - the 2-Step Floating Catchment Area measure was the first
accessibility metric in the FCA family. It was originally proposed by
\insertCite{luo2003measures;textual}{accessibility}.
\item BFCA - the Balanced Floating Catchment Area measure calculates
accessibility accounting for competition effects while simultaneously
correcting for issues of inflation of demand and service levels that are
present in other FCA measures. It was originally proposed by
\insertCite{paez2019demand;textual}{accessibility} and named in
\insertCite{pereira2021geographic;textual}{accessibility}.
}
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

# 2SFCA with a step decay function
df <- floating_catchment_area(
  travel_matrix,
  land_use_data,
  method = "2sfca",
  decay_function = decay_binary(cutoff = 50),
  opportunity = "jobs",
  travel_cost = "travel_time",
  demand = "population"
)
head(df)


# BFCA with an exponential decay function
df <- floating_catchment_area(
  travel_matrix,
  land_use_data,
  method = "bfca",
  decay_function = decay_exponential(decay_value = 0.5),
  opportunity = "jobs",
  travel_cost = "travel_time",
  demand = "population"
)
head(df)
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
\concept{Floating catchment area}
