% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations_delete_empty.R
\name{annotations_delete_empty}
\alias{annotations_delete_empty}
\title{Delete empty annotations}
\usage{
annotations_delete_empty(
  x,
  trimBeforeCheck = FALSE,
  filterTranscriptNames = NULL,
  filterTierNames = NULL
)
}
\arguments{
\item{x}{Corpus object.}

\item{trimBeforeCheck}{Logical; if \code{TRUE} leading and trailing spaces will be deleted before checking (as a consequence record sets that contain only spaces will be deleted, too).}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}

\item{filterTierNames}{Character string; names of the tiers to be included.}
}
\value{
Corpus object.
}
\description{
Delete empty annotations in a corpus object.
If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames} and \code{filterTierNames}.
In case that you want to select transcripts and/or tiers by using regular expressions use the function \code{act::search_meta} first.
}
\examples{
library(act)

# In the example corpus are no empty annotations.
# Empty annotations are deleted by default when annotation files are loaded.
# So let's first make an empty annotation.

# Check the first annotation in the first transcript
examplecorpus@transcripts[[1]]@annotations$content[[1]]

# Empty the contents of this annotation
examplecorpus@transcripts[[1]]@annotations$content[[1]] <- ""

# Run the function
test <- act::annotations_delete_empty (x=examplecorpus)

# Compare how many data rows are in the first transcript in
# the example corpus and in the newly created test corpus:
nrow(examplecorpus@transcripts[[1]]@annotations)
nrow(test@transcripts[[1]]@annotations)

}
