% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import a single annotation file}
\usage{
import(..., transcriptName = NULL)
}
\arguments{
\item{...}{file path, contents of an annotation file or rPraat object; see description above.}

\item{transcriptName}{Character string; name of the transcript, if this parameter is set, the default name of the transcript will be changed.}
}
\value{
Transcript object.
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_new}, \code{act::corpus_import} for importing annotation files.
}
\details{
Imports the contents of an annotation file and returns a transcript object.

The input to this function in the parameter '...' may either be 
(1) the path to an annotation file (Currently 'ELAN' .eaf, 'EXMARaLDA .exb and 'Praat' .TextGrid files),
(2) the contents of an annotation file obtained from the \code{@file.content} or by reading the contents of the files directly with \code{read.lines()} or
(3) a \code{rPraat} TextGrid object.

Only the first input to '...' will be processed
}
\examples{
library(act)

# To import an annotation file of your choice:
\dontrun{
	path <- "PATH_TO_AN_EXISTING_FILE_ON_YOUR_COMPUTER"
}

# Path to a .TextGrid file that you want to read
filePath <- system.file("extdata", "examplecorpus", "GAT", 
						"ARG_I_PAR_Beto.TextGrid", package="act")
t <- act::import(filePath=filePath)
t

# Path to an .eaf file that you want to read
filePath <- system.file("extdata", "examplecorpus", "SYNC", 
						"SYNC_rotar_y_flexionar.eaf", package="act")
t <- act::import(filePath=filePath)
t

# Content of a .TextGrid file, e.g. as stored in \code{@file.content} 
# of a transcript object.
fileContent <- examplecorpus@transcripts[['ARG_I_CHI_Santi']]@file.content
t <- act::import(fileContent=fileContent)
t

# Content of an .eaf file, e.g. as stored in \code{@file.content} 
# of a transcript object.
fileContent <- examplecorpus@transcripts[['SYNC_rotar_y_flexionar']]@file.content
t <- act::import(fileContent=fileContent)
t

}
\seealso{
\code{corpus_import}, \code{corpus_new}, \code{import_eaf}, \code{import_exb}, \code{import_rpraat}, \code{import_textgrid}
}
