% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{compareCkern}
\alias{compareCkern}
\title{Compare circular distributions.}
\usage{
compareCkern(fit1, fit2, reps = 999)
}
\arguments{
\item{fit1, fit2}{Fitted activity models of class actmod created using function fitact.}

\item{reps}{Number of bootstrap iterations.}
}
\value{
A named 4-element vector: obs = observed overlap index; null = mean null overlap index; seNull = standard error of the null distribution; pNull = probability observed index arose by chance.
}
\description{
Randomisation test for the probability that two sets of circular observations come from the same distribution.
}
\details{
Calculates overlap index Dhat4 (see references) for the two fitted distributions, then generates a null distribution of overlap indices using data sampled randomly with replacement from the combined data.
This randomised distribution is then used to define an empirical probability distribution against which  the probability that the observed overlap arose by chance is judged.
When one or both fitted models use weighted distributions, sampling probabilities are taken from the weights. If both models are weighted, the weights must therefore be on the same scale.
}
\examples{
#Example with bootstrap reps limited to reduce run time
data(BCItime)
tPaca <- 2*pi*BCItime$time[BCItime$species=="paca"]
tRat <- 2*pi*BCItime$time[BCItime$species=="rat"]
fPaca <- fitact(tPaca)
fRat <- fitact(tRat)
compareCkern(fPaca,fRat,reps=10)
}
\references{
Ridout, M.S. & Linkie, M. (2009) Estimating overlap of daily activity patterns from camera trap data. Journal of Agricultural Biological and Environmental Statistics, 14, 322-337.
}
