% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{transtime}
\alias{transtime}
\title{Transforms clock time to solar times.}
\usage{
transtime(dat, anchor, mnanchor = NULL, type = c("average",
  "equinoctial", "single"))
}
\arguments{
\item{dat}{A vector of radian event clock times.}

\item{anchor}{A vector or matrix matched with \code{dat} containing radian anchor times on the day of each event (see Details).}

\item{mnanchor}{A scalar or two-element vector of numeric radian mean anchor times (see Details).}

\item{type}{The type of transformation to use (see Details).}
}
\value{
A vector of radian transformed times.
}
\description{
Transforms time expressed relative to either the time of a single solar event (anchor times - Nouvellet et al. 2012), or two solar events (such as sun rise and sun set - Vazquez et al. in press).
}
\details{
If double anchoring is requested (i.e. \code{type} is equinoctial
or average), the \code{anchor} argument requires a two-column matrix,
otherwise a vector. The argument \code{mnanchor} can usually be left at
its default \code{NULL} value. In this case, the mean anchors are set to
\code{c(pi/2, pi*3/2)} when \code{type}=="equinoctial", otherwise the
\code{anchor} mean(s).

Although the anchors for transformation are usually likely to be solar
events (e.g. sun rise and/or sunset), they could be other celestial
(e.g. lunar) or human-related (e.g. timing of artificial lighting) events.
}
\examples{
data(BCItime)
subdat <- subset(BCItime, species=="ocelot")
jdate <- insol::JD(strptime(subdat$date, "\%d/\%m/\%Y \%H:\%M", "UTC"))
suntimes <- pi/12 * insol::daylength(9.156335, -79.847682, jdate, -5)[, -3]
rawtimes <- subdat$time*2*pi
avgtimes <- transtime(rawtimes, suntimes)
eqntimes <- transtime(rawtimes, suntimes, type="equinoctial")
sngtimes <- transtime(rawtimes, suntimes[,1], type="single")
rawAct <- fitact(rawtimes)
avgAct <- fitact(avgtimes)
eqnAct <- fitact(eqntimes)
sngAct <- fitact(sngtimes)
plot(rawAct)
plot(avgAct, add=TRUE, data="n", tline=list(col="magenta"))
plot(eqnAct, add=TRUE, data="n", tline=list(col="orange"))
plot(sngAct, add=TRUE, data="n", tline=list(col="cyan"))
}
\references{
Vazquez, C., Rowcliffe, J.M., Spoelstra, K. and Jansen, P.A. in press. Comparing diel activity patterns of wildlife across latitudes and seasons: time transformation using day length. Methods in Ecology and Evolution.

Nouvellet, P., Rasmussen, G.S.A., Macdonald, D.W. and Courchamp, F. 2012. Noisy clocks and silent sunrises: measurement methods of daily activity pattern. Journal of Zoology 286: 179-184.
}
