% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outl_toler.R
\name{outl_toler}
\alias{outl_toler}
\title{Tolerance outliers}
\usage{
outl_toler(p_tol = 0.95, resid_vect, alpha = 0.05)
}
\arguments{
\item{p_tol}{The proportion of observations to be covered by this 
tolerance interval.}

\item{resid_vect}{Vector of n residuals, where n was the number of rows
of the data matrix.}

\item{alpha}{Significance level.}
}
\value{
Vector with the outliers.
}
\description{
Outliers according to a tolerance interval. This function is used by 
the archetypoid algorithms to identify the outliers. See the function
\code{nptol.int} in package \code{tolerance}.
}
\examples{
outl_toler(0.95, 1:100, 0.05)
                                                     
}
\seealso{
\code{\link{adalara}}, \code{\link{fadalara}}, \code{\link{do_outl_degree}}
}
\author{
Guillermo Vinue
}
