% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Digest.R
\name{Digest}
\alias{Digest}
\title{Digest files from (digest package)}
\usage{
Digest(object = NULL, algo = checkAdaprHashAlgo(), serialize = FALSE,
  file = TRUE, length = Inf, skip = "auto", ascii = FALSE,
  raw = FALSE)
}
\arguments{
\item{object}{R object or file}

\item{algo}{digest hash algorithm}

\item{serialize}{FALSE allows hash comparison of known output}

\item{file}{logical TRUE iff object is file}

\item{length}{Size of object/file to hash}

\item{skip}{How many input bytes to skip for computing hash}

\item{ascii}{ASCII or binary compression}

\item{raw}{logical digest output in binary form}
}
\value{
The filehash
}
\description{
Compute file hash without checking file.access
}
\details{
Uses digest from package "digest". Authors Dirk Eddelbuettel edd@debian.org for the R interface; Antoine Lucas for the integration of crc32; Jarek Tuszynski for the file-based operations; Henrik Bengtsson and Simon Urbanek for improved serialization patches; Christophe Devine for the hash function implementations for sha-1, sha-256 and md5; Jean-loup Gailly and Mark Adler for crc32; Hannes Muehleisen for the integration of sha-512; Jim Hester for the integration of xxhash32, xxhash64 and murmur32.
}
\examples{
\dontrun{
 file0 <- file.path(pullSourceInfo("adaprHome")$project.path,
 project.directory.tree$analysis,"read_data.R")
 Digest(file=file0)
} 

}
