% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_load_leverage.R
\name{adea_load_leverage}
\alias{adea_load_leverage}
\title{Search for leverage units (DMU's) with higher impact on load levels in DEA analysis}
\usage{
adea_load_leverage(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  load.diff = 0.05,
  ndel = 1,
  nmax = 0
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or use "output" for output orientation in DEA model.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{load.diff}{Minimum difference in load to consider a subset of DMUs as a leverage one}

\item{ndel}{Maximum number of units to drop out in each try.}

\item{nmax}{Maximum number of DMU sets to include in results. 0 for no limit.}
}
\value{
The indexes of units with higher impact on load levels.
}
\description{
Search for leverage units (DMU's) with higher impact on load levels in DEA analysis.
}
\note{
This function has to solve a large number of large linear programs that grows with DMUs. So computation time required may be very large, be patient.
}
\examples{
data('cardealers4')
input <- cardealers4[, 1:2]
output <- cardealers4[, 3:4]
adea_load_leverage(input, output, ndel = 2)

}
