\name{distinctTree}
\alias{distinctTree}
\title{
Tree-based Species' Originality 
}
\description{
The function calculates two indices of species' originality that rely on the structure and branch lengths of (phylogenetic) trees.
}
\usage{
distinctTree(phyl, method = c("ED", "ES"), standardized = FALSE)
}
\arguments{
  \item{phyl}{
an object inheriting the class \code{phylo} (see package ape), \code{phylo4} (see package phylobase) or \code{hclust}. Polytomies are allowed.
}
  \item{method}{
a character a vector of characters. Possible values are \code{"ED"} and \code{"ES"}. \code{"ED"} is for the evolutionary distinctiveness, also named fair-proportion, index (Redding 2003; Isaac et al. 2007); \code{"ES"} is for the Equal-Splits index (Redding and Mooers 2006).
}
  \item{standardized}{
a logical. If \code{TRUE}, the vector of originalities is divided by its sum (transforming absolute originalities into relative originalities).
}
}
\value{
A data frame with species as rows and originality indices as columns.
}
\references{
Redding, D.W. (2003) \emph{Incorporating genetic distinctness and reserve occupancy into a conservation priorisation approach}. Master thesis: University of East Anglia, Norwich.

Redding, D.W., Mooers, A.O. (2006) Incorporating evolutionary measures into conservation prioritization. \emph{Conservation Biology}, \bold{20}, 1670--1678.

Isaac, N.J., Turvey, S.T., Collen, B., Waterman, C., Baillie, J.E. (2007) Mammals on the EDGE: conservation priorities based on threat and phylogeny. \emph{PloS ONE}, \bold{2}, e296.
}
\author{
Sandrine Pavoine \email{sandrine.pavoine@mnhn.fr}
}
\seealso{
See Also \code{\link{distinctDis}}, \code{\link{distinctTopo}}, \code{\link{distinctUltra}}
}
\examples{
data(carni70, package = "adephylo")
tre <- read.tree(text=carni70$tre)
U <- distinctTree(tre, standardize = TRUE)
U.4d <- phylo4d(tre, as.matrix(U))
parmar <- par()$mar
par(mar=rep(.1,4))
table.phylo4d(U.4d, show.node=FALSE, symbol="squares", center=FALSE, scale=FALSE, cex.symbol=2)
par(mar=parmar)
}
\keyword{models}
