% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_date_vars.R
\name{compute_dtf}
\alias{compute_dtf}
\title{Derive the Date Imputation Flag}
\usage{
compute_dtf(dtc, dt)
}
\arguments{
\item{dtc}{The date character vector (\code{'--DTC'}).

A character date is expected in a format like \code{yyyy-mm-ddThh:mm:ss} (partial or complete).}

\item{dt}{The  Date vector to compare.

A date object is expected.}
}
\value{
The date imputation flag (\code{'--DTF'}) (character value of \code{'D'}, \code{'M'} , \code{'Y'} or \code{NA})
}
\description{
Derive the date imputation flag (\code{'--DTF'}) comparing a date character vector
(\code{'--DTC'}) with a Date vector (\code{'--DT'}).
}
\details{
Usually this computation function can not be used with \verb{\%>\%}.
}
\examples{
compute_dtf(dtc = "2019-07", dt = as.Date("2019-07-18"))
compute_dtf(dtc = "2019", dt = as.Date("2019-07-18"))
}
\author{
Samia Kabi
}
\keyword{computation}
\keyword{timing}
