% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianity_test.R
\name{gaussianity_test}
\alias{gaussianity_test}
\title{Gaussianity test in an admixture model}
\usage{
gaussianity_test(
  sample1,
  admixMod,
  conf_level = 0.95,
  K = 3,
  s = 0.25,
  support = c("Real", "Integer", "Positive", "Bounded.continuous")
)
}
\arguments{
\item{sample1}{Sample under study.}

\item{admixMod}{An object of class 'admix_model', containing useful information about distributions and parameters.}

\item{conf_level}{(default to 0.95) The confidence level. Equals 1-alpha, where alpha is the level of the test (type-I error).}

\item{K}{(K > 0) Number of coefficients considered for the polynomial basis expansion.}

\item{s}{Normalization rate involved in the penalization rule for model selection (in ]0,1/2[). See the reference below.}

\item{support}{Support of the probability density functions, useful to choose the polynomial orthonormal basis. One of 'Real',
'Integer', 'Positive', or 'Bounded.continuous'.}
}
\value{
An object of class 'gaussianity_test', containing 10 elements: 1) the number of populations under study (1 in this case);
2) the sample size; 3) the information about the known component distribution; 4) the reject decision of the test; 5) the
confidence level of the test, 6) the p-value of the test; 7) the value of the test statistic; 8) the variance of the test
statistic at each order in the polynomial orthobasis expansion; 9) the selected rank (order) for the test statistic;
10) a list of estimates (mixing weight, mean and standard deviation of the Gaussian unknown distribution).
}
\description{
Performs an hypothesis test to check for the gaussianity of the unknown mixture component, given that the known component
has support on the real line. Recall that an admixture model has probability density function (pdf) l = p*f + (1-p)*g, where g is
the known pdf and l is observed (others are unknown). This test requires optimization (to estimate the unknown parameters) as
defined by Bordes & Vandekerkhove (2010), which means that the unknown mixture component must have a symmetric density.
}
\details{
Extensions to the case of non-Gaussian known components can be overcome thanks to basic transformations using cdf.
}
\examples{
####### Under the null hypothesis H0.
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 250, weight = 0.4,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(c("mean" = -2, "sd" = 0.5),
                                        c("mean" = 0, "sd" = 1)))
data1 <- getmixtData(mixt1)

## Define the admixture models:
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
## Performs the test:
gaussianity_test(sample1 = data1, admixMod = admixMod1,
                 conf_level = 0.95, K = 3, s = 0.1, support = 'Real')

}
\references{
\insertRef{PommeretVandekerkhove2019}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
